from flask import Blueprint, render_template, abort, redirect, url_for
from app import get_db # Import the get_db function from your main app file

tour_bp = Blueprint('tour', __name__)

# -------------------------------------------------------
# Route: Show All Tours
# -------------------------------------------------------
@tour_bp.route('/tours')
def tours():
    try:
        # Get the database connection for this request
        conn = get_db()
        cur = conn.cursor(dictionary=True)
        
        print("--- [TOURS] Running SQL Query: SELECT title, slug, image, category, content FROM tours")
        cur.execute("SELECT title, slug, image, category, content FROM tours")
        
        tours_data = cur.fetchall()
        cur.close()

        return render_template('tour/tours.html', tours=tours_data)
        
    except Exception as e:
        print(f"--- [TOURS] Database Error: {e} ---")
        abort(500, description="Could not connect to the database to fetch tours.")

# -------------------------------------------------------
# Route: Show Single Tour by Slug
# -------------------------------------------------------
@tour_bp.route('/tour/<string:slug>')
def tour(slug):
    print(f"\n--- [TOUR] /tour/{slug} route hit ---")
    try:
        # Get the database connection for this request
        conn = get_db()
        cur = conn.cursor(dictionary=True)
        
        query = "SELECT id, title, slug, image, category, content FROM tours WHERE slug = %s"
        cur.execute(query, (slug,))
        
        tour_data = cur.fetchone()
        cur.close()

        if tour_data is None:
            print(f"--- [TOUR] No tour found for slug '{slug}'. Redirecting to home. ---")
            return redirect(url_for('home'))

        print(f"--- [TOUR] Tour Found: {tour_data} ---")
        return render_template('tour/tour.html', tour=tour_data)

    except Exception as e:
        print(f"--- [TOUR] Database Error: {e} ---")
        abort(500, description="Could not connect to the database to fetch this tour.")