$('.parallax-slider').slick({
  dots: true,
  infinite: false,
  speed: 300,
  slidesToShow: 4,
  slidesToScroll: 4,
  responsive: [
    {
      breakpoint: 1024,
      settings: {
        slidesToShow: 3,
        slidesToScroll: 3,
        infinite: true,
        dots: true
      }
    },
    {
      breakpoint: 600,
      settings: {
        slidesToShow: 2,
        slidesToScroll: 2
      }
    },
    {
      breakpoint: 480,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1
      }
    }


    // You can unslick at a given breakpoint now by adding:
    // settings: "unslick"
    // instead of a settings object
  ]
});


window.addEventListener("scroll", function () {
  const navbar = document.querySelector(".main-menu");
  if (window.scrollY > 50) { // Scroll threshold
    navbar.classList.add("sticky-navbar");
  } else {
    navbar.classList.remove("sticky-navbar");
  }
});


// Get the button
let mybutton = document.getElementById("backToTopBtn");

// When the user scrolls, run the function
window.onscroll = function () {
  scrollFunction()
};

function scrollFunction() {
  if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
    mybutton.style.display = "block";
  } else {
    mybutton.style.display = "none";
  }
}

// When the user clicks, scroll to top
function scrollToTop() {
  window.scrollTo({ top: 0, behavior: 'smooth' });
}


$(document).ready(function () {
  function startTicker() {
    // Clone the first news item and append it to the end
    $('.news-list li:first').clone(true).appendTo('.news-list');

    // Get the width of the first item
    const firstItemWidth = $('.news-list li:first').outerWidth(true);

    // Animate the list to the left by the width of the first item
    $('.news-list').animate({
      'marginLeft': -firstItemWidth
    }, 10000, 'linear', function () { // Adjust speed here (10000ms = 10s)
      // After animation, remove the original first item
      $('.news-list li:first').remove();
      // Reset the margin
      $('.news-list').css('marginLeft', 0);
      // Repeat the process
      startTicker();
    });
  }

  // Start the ticker
  startTicker();
});



// gallery
document.addEventListener("DOMContentLoaded", function() {
    // CORRECTED LINE: Select the 'a' tags that trigger the modal directly.
    const galleryLinks = document.querySelectorAll('a[data-bs-toggle="modal"]');
    
    // The rest of your code is correct and can remain as is.
    const lightboxImage = document.getElementById('lightboxImage');
    const lightboxCaption = document.getElementById('lightboxCaption');
    const thumbnailCarousel = document.getElementById('thumbnailCarousel');
    const imageLightbox = document.getElementById('imageLightbox');

    let currentImageIndex = 0;
    const images = [];

    // Populate images array and create thumbnail elements
    galleryLinks.forEach((link, index) => {
        images.push({
            full: link.getAttribute('href'),
            thumb: link.getAttribute('data-thumb'),
            caption: link.getAttribute('data-caption')
        });

        // Create thumbnail for the modal carousel
        const thumbItem = document.createElement('div');
        thumbItem.classList.add('thumb-item');
        thumbItem.setAttribute('data-idx', index);
        thumbItem.innerHTML = `<img src="${link.getAttribute('data-thumb')}" alt="Thumbnail ${index + 1}">`;
        
        // Add click listener to thumbnails to change the main lightbox image
        thumbItem.addEventListener('click', function() {
            showImage(parseInt(this.getAttribute('data-idx')));
        });
        thumbnailCarousel.appendChild(thumbItem);
    });

    // Function to update the lightbox content
    function showImage(index) {
        if (index < 0) {
            currentImageIndex = images.length - 1; // Loop to last image
        } else if (index >= images.length) {
            currentImageIndex = 0; // Loop to first image
        } else {
            currentImageIndex = index;
        }

        const imageData = images[currentImageIndex];
        lightboxImage.src = imageData.full;
        lightboxCaption.textContent = imageData.caption;

        // Update active thumbnail
        document.querySelectorAll('.thumbnail-carousel .thumb-item').forEach(item => {
            item.classList.remove('active');
        });
        const activeThumb = document.querySelector(`.thumbnail-carousel .thumb-item[data-idx="${currentImageIndex}"]`);
        if (activeThumb) {
            activeThumb.classList.add('active');
            // Scroll active thumbnail into view if necessary
            activeThumb.scrollIntoView({ behavior: 'smooth', inline: 'center' });
        }
    }

    // Event listener for opening the modal
    imageLightbox.addEventListener('show.bs.modal', function(event) {
        // Get the link that triggered the modal
        const button = event.relatedTarget;
        const initialIndex = parseInt(button.getAttribute('data-idx'));
        showImage(initialIndex);
    });

    // Event listeners for previous/next buttons
    document.getElementById('prevBtn').addEventListener('click', function() {
        showImage(currentImageIndex - 1);
    });

    document.getElementById('nextBtn').addEventListener('click', function() {
        showImage(currentImageIndex + 1);
    });

    // Optional: Keyboard navigation for left/right arrows
    document.addEventListener('keydown', function(event) {
        if (imageLightbox.classList.contains('show')) { // Only if modal is open
            if (event.key === 'ArrowLeft') {
                showImage(currentImageIndex - 1);
            } else if (event.key === 'ArrowRight') {
                showImage(currentImageIndex + 1);
            }
        }
    });
});

$(document).ready(function() {
    var videoModal = document.getElementById('videoModal');
    var videoIframe = document.getElementById('videoIframe');

    // Event listener for when the modal is about to be shown
    videoModal.addEventListener('show.bs.modal', function(event) {
        // Get the button that triggered the modal
        var button = event.relatedTarget;
        // Extract the video URL from the data-bs-src attribute
        var videoSrc = button.getAttribute('data-bs-src');
        
        // Update the iframe's src attribute to play the video
        // We add "?autoplay=1" to make the video play automatically
        videoIframe.setAttribute('src', videoSrc + "?autoplay=1&amp;modestbranding=1&amp;showinfo=0");
    });

    // Event listener for when the modal is hidden
    videoModal.addEventListener('hide.bs.modal', function() {
        // Stop the video by clearing the iframe's src
        videoIframe.setAttribute('src', '');
    });
});