from flask import Blueprint, render_template, abort

# Create a new blueprint for gallery
gallery_bp = Blueprint('gallery', __name__, url_prefix='/gallery')

# --- Photo Gallery Route (fetching from MySQL) ---
@gallery_bp.route('/photo')
def photo():
    # Import get_db inside the function to avoid the circular import
    from app import get_db 
    try:
        # Get the database connection for this request
        conn = get_db()
        
        # Use a dictionary cursor to get results as dictionaries
        cur = conn.cursor(dictionary=True)
        
        # SQL query to select all visible images from your table
        print("--- [GALLERY] Running SQL Query: SELECT image, caption FROM gallery WHERE visibility = 1 ORDER BY created_at DESC")
        cur.execute("SELECT image, caption FROM gallery WHERE visibility = 1 ORDER BY created_at DESC")
        
        gallery_items = cur.fetchall()
        cur.close()

        # Pass the database records to the template
        return render_template('gallery/photo.html', gallery_items=gallery_items)
        
    except Exception as e:
        # If the database connection fails, show an error page
        print(f"--- [GALLERY] Database Error: {e} ---")
        abort(500, description="Could not connect to the database to fetch the gallery.")

# --- Video Gallery Route (no database access, no changes needed) ---
@gallery_bp.route('/video')
def video():
    video_data = [
        {
            "title": "Corbett National Park Safari",
            "embed_url": "https://www.youtube.com/embed/z-pe2xK2q5I" 
        },
        {
            "title": "Exploring the Mangroves of Bhitarkanika",
            "embed_url": "https://www.youtube.com/embed/exampleVideoId2"
        }
    ]
    return render_template('gallery/video.html', videos=video_data)